# načtení dat
with open('filmy_2.csv', mode='tr', encoding='utf-8') as soubor:
    data = soubor.readlines()

# příprava dat
data = [d.strip() for d in data]        # odstranění \n
filmy = [d.split(';') for d in data]    # rozdělení podle ;
print(filmy)

# tisk dat
for film in sorted(filmy, key=lambda x: int(x[-1][1:].replace(',', '_')), reverse=True):
    _, název, rok, režisér, tržby = film
    print(f'{název} ({rok}; r. {režisér}) => {tržby}')
